<?php

namespace App\Models\HR;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Appointment extends Model 
{

    protected $table = 'appointments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function position()
    {
        return $this->belongsTo('App\Models\HR\Position', 'position_id');
    }

    public function person()
    {
        return $this->belongsTo('App\Models\Person\Person', 'person_id');
    }

    public function holidays()
    {
        return $this->hasMany('App\Models\HR\Holiday', 'appointment_id');
    }

    public function holidays_approved()
    {
        return $this->hasMany('App\Models\HR\Holiday', 'approver_id');
    }

    public function pay_rates()
    {
        return $this->hasMany('App\Models\HR\PayRate', 'appointment_id');
    }

    public function sicknesses()
    {
        return $this->hasMany('App\Models\HR\Sickness', 'appointment_id');
    }

    public function gross_pay()
    {
        return $this->hasMany('App\Models\HR\AppointmentGrossPay', 'appointment_id');
    }

    public function timesheets()
    {
        return $this->hasMany('App\Models\HR\Timesheet', 'appointment_id');
    }

    public function contracts()
    {
        return $this->belongsToMany('App\Models\HR\Contract', 'appointments_contracts', 'appointment_id', 'contract_id');
    }

    public function sickness_approved()
    {
        return $this->hasMany('App\Models\HR\Sickness', 'approver_id');
    }

}